#include <cstdio>
#include <cstdlib>
#include <cstring>
#include <cmath>
#include <ctime>
#include <cctype>
#include <iostream>
#include <iomanip>
#include <fstream>
#include <sstream>
#include <string>
#include <vector>
#include <set>
#include <algorithm>
#include <map>

using namespace std;

typedef long long ll;
typedef long double ld;
typedef long long unsigned ull;
typedef unsigned uint;

template <class T> inline T sqr(T x) { return x * x; }
template <class T> inline void updMin(T& a, const T& b) { if (b < a) a = b; }
template <class T> inline void updMax(T& a, const T& b) { if (b > a) a = b; }

set< pair< ll, ll > > used;

ll
getVal(const set< pair< ll, ll > > &st, ll x)
{
	set< pair< ll, ll > >::const_iterator it = st.lower_bound(make_pair(x, -1));
	if (it->first != x) {
		--it;
	}
	return max(x, it->second + 1);
}

void
insertPoint(set< pair< ll, ll > > &st, ll x)
{
	set< pair< ll, ll > >::iterator it1 = st.lower_bound(make_pair(x, x));
	set< pair< ll, ll > >::iterator it2 = it1; it2--;
	if (it2->second == x - 1) {
		if (it1->first == x + 1) {
			pair< ll, ll > t1 = *it1, t2 = *it2;
			st.erase(t1);
			st.erase(t2);
			st.insert(make_pair(t2.first, t1.second));
		} else {
			pair< ll, ll > t = *it2;
			st.erase(t);
			st.insert(make_pair(t.first, x));
		}
	} else {
		if (it1->first == x + 1) {
			pair< ll, ll > t = *it1;
			st.erase(t);
			st.insert(make_pair(x, t.second));
		} else {
			st.insert(make_pair(x, x));
		}
	}
}

bool cmp(const pair< ll, ll > &a, const pair< ll, ll > &b)
{
	return (a.second < b.second || a.second == b.second && a.first < b.first);
}

void process()
{
	vector< pair< ll, ll > > tmp;
	int n, m;
	scanf("%d%d", &m, &n);
	for (int i = 0; i < n; ++i) {
		int a, b;
		scanf("%d%d", &a, &b);
		if (a <= b) {
			tmp.push_back(make_pair(a, b));
			tmp.push_back(make_pair(a + m, b + m));
		} else {
			tmp.push_back(make_pair(a, b + m));
		}
	}
	sort(tmp.begin(), tmp.end(), cmp);
	if (n > m) {
		printf("NO\n");
		return;
	}
	set< pair< ll, ll > > ok;
	ok.insert(make_pair(-m, -1));
	ok.insert(make_pair(2ll * m + 2, 3ll * m));
	for (vector< pair< ll, ll > >::const_iterator it = tmp.begin(); it != tmp.end(); ++it) {
		ll beg = it->first, en = it->second;
		ll getPoint = getVal(ok, beg);
		if (getPoint > en) {
			printf("NO\n");
			return;
		}
		insertPoint(ok, getPoint);
	}
	printf("YES\n");
}

int main()
{
	//freopen("input.txt", "r", stdin); freopen("output.txt", "w", stdout);
	int t;
	scanf("%d", &t);
	for (int i = 0; i < t; ++i) {
		process();
	}
	return 0;
}